/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.instance.SpreadSubsample;

public class SpreadSubsampleTest
extends AbstractFilterTest {
    private static double TOLERANCE = 0.001;

    public SpreadSubsampleTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        SpreadSubsample f = new SpreadSubsample();
        f.setDistributionSpread(0.0);
        return f;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    public void testDistributionSpread() throws Exception {
        this.testDistributionSpread_X(1.0);
        this.testDistributionSpread_X(2.0);
        this.testDistributionSpread_X(3.0);
    }

    public void testAdjustWeights() {
        ((SpreadSubsample)this.m_Filter).setAdjustWeights(true);
        Instances result = this.useFilter();
        SpreadSubsampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        double origWeight = 0.0;
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            origWeight += this.m_Instances.instance(i).weight();
            ++i;
        }
        double outWeight = 0.0;
        int i2 = 0;
        while (i2 < result.numInstances()) {
            outWeight += result.instance(i2).weight();
            ++i2;
        }
        SpreadSubsampleTest.assertEquals(origWeight, outWeight, TOLERANCE);
    }

    private void testDistributionSpread_X(double factor) throws Exception {
        AttributeStats origs = this.m_Instances.attributeStats(1);
        SpreadSubsampleTest.assertNotNull(origs.nominalCounts);
        ((SpreadSubsample)this.m_Filter).setDistributionSpread(factor);
        Instances result = this.useFilter();
        SpreadSubsampleTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        AttributeStats outs = result.attributeStats(1);
        SpreadSubsampleTest.assertNotNull(outs.nominalCounts);
        SpreadSubsampleTest.assertEquals(origs.nominalCounts.length, outs.nominalCounts.length);
        int min = outs.nominalCounts[0];
        int max = outs.nominalCounts[0];
        int i = 1;
        while (i < outs.nominalCounts.length) {
            if (outs.nominalCounts[i] < min) {
                min = outs.nominalCounts[i];
            }
            if (outs.nominalCounts[i] > max) {
                max = outs.nominalCounts[i];
            }
            ++i;
        }
        SpreadSubsampleTest.assertTrue((double)max / factor <= (double)min);
    }

    public static Test suite() {
        return new TestSuite(SpreadSubsampleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(SpreadSubsampleTest.suite());
    }
}

